/*
 * Decompiled with CFR 0.152.
 */
package com.stclab.botmanager.agent.utils;

import com.stclab.botmanager.agent.utils.TransformUtils;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestUtils.class);

    public static String getQueryParameter(Object request, String paramName) {
        try {
            Method getParameterMethod = request.getClass().getMethod("getParameter", String.class);
            String value = (String)getParameterMethod.invoke(request, paramName);
            LOGGER.debug("[RequestUtils] Found param {} with value: {}", (Object)paramName, (Object)value);
            return value;
        }
        catch (NoSuchMethodException e) {
            LOGGER.debug("[RequestUtils] getParameter not found, falling back to getQueryString: {}", (Object)request.getClass().getName());
            try {
                String queryString = (String)RequestUtils.invokeMethod(request, "getQueryString", null, null);
                LOGGER.debug("[RequestUtils] Raw queryString for param {}: {}", (Object)paramName, (Object)queryString);
                if (queryString != null && !queryString.isEmpty()) {
                    String[] params = queryString.split("&");
                    LOGGER.debug("[RequestUtils] Parsed params: {}", (Object)params);
                    for (String param : params) {
                        if (param.isEmpty()) {
                            LOGGER.debug("[RequestUtils] Skipping empty param");
                            continue;
                        }
                        String[] keyValue = param.split("=", 2);
                        if (keyValue.length < 1 || !paramName.equals(keyValue[0])) continue;
                        String value = keyValue.length == 2 ? keyValue[1] : "";
                        LOGGER.debug("[RequestUtils] Found param {} with value (fallback): {}", (Object)paramName, (Object)value);
                        return TransformUtils.decodeUri(value);
                    }
                    LOGGER.debug("[RequestUtils] Param {} not found in queryString", (Object)paramName);
                } else {
                    LOGGER.debug("[RequestUtils] Query string is null or empty for param: {}", (Object)paramName);
                }
            }
            catch (Exception ex) {
                LOGGER.error("[RequestUtils] Failed to get query parameter in fallback {}: {}", paramName, ex.getMessage(), ex);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("[RequestUtils] Failed to get query parameter {}: {}", paramName, e.getMessage(), e);
            return null;
        }
    }

    private static <T> T invokeMethod(Object obj, String methodName, Class<?>[] paramTypes, Object[] args2) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException("Request object is null");
        }
        paramTypes = paramTypes != null ? paramTypes : new Class[]{};
        args2 = args2 != null ? args2 : new Object[]{};
        Method method = obj.getClass().getMethod(methodName, paramTypes);
        return (T)method.invoke(obj, args2);
    }
}

