/*
 * Decompiled with CFR 0.152.
 */
package com.stclab.botmanager.agent.utils;

public class IPUtils {
    public static String filterToIPv4(String ip) {
        String potentialIPv4;
        int lastColonIndex;
        if (ip == null || ip.isEmpty()) {
            return null;
        }
        if ("0:0:0:0:0:0:0:1".equals(ip)) {
            return "127.0.0.1";
        }
        if (ip.contains(",")) {
            String[] ips;
            for (String part : ips = ip.split(",")) {
                String filteredIp = IPUtils.filterToIPv4(part.trim());
                if (filteredIp == null) continue;
                return filteredIp;
            }
        }
        if (ip.contains(":") && (lastColonIndex = ip.lastIndexOf(58)) != -1 && ip.length() > lastColonIndex + 1 && IPUtils.isValidIPv4(potentialIPv4 = ip.substring(lastColonIndex + 1))) {
            return potentialIPv4;
        }
        if (IPUtils.isValidIPv4(ip)) {
            return ip;
        }
        return null;
    }

    public static boolean isValidIPv4(String ip) {
        String[] segments;
        if (ip == null || ip.isEmpty()) {
            return false;
        }
        String ipv4Pattern = "^([0-9]{1,3}\\.){3}[0-9]{1,3}$";
        if (!ip.matches(ipv4Pattern)) {
            return false;
        }
        for (String segment : segments = ip.split("\\.")) {
            try {
                int value = Integer.parseInt(segment);
                if (value >= 0 && value <= 255) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean isPrivateIP(String ip) {
        if (ip == null || ip.isEmpty()) {
            return false;
        }
        if (!IPUtils.isValidIPv4(ip)) {
            return false;
        }
        String[] parts = ip.split("\\.");
        int first = Integer.parseInt(parts[0]);
        int second = Integer.parseInt(parts[1]);
        if (first == 127) {
            return true;
        }
        if (first == 10) {
            return true;
        }
        if (first == 172 && second >= 16 && second <= 31) {
            return true;
        }
        if (first == 192 && second == 168) {
            return true;
        }
        return first == 169 && second == 254;
    }

    public static String getBestClientIP(String[] headerValues, String remoteAddr) {
        return IPUtils.getBestClientIP(headerValues, remoteAddr, null, false);
    }

    public static String getBestClientIP(String[] headerValues, String remoteAddr, String[] customHeaderValues, boolean useDirectConnectionOnly) {
        String filteredRemoteAddr;
        String filteredIP;
        if (useDirectConnectionOnly) {
            return IPUtils.filterToIPv4(remoteAddr);
        }
        String publicIP = null;
        String privateIP = null;
        if (customHeaderValues != null) {
            for (String customHeaderValue : customHeaderValues) {
                if (customHeaderValue == null || customHeaderValue.isEmpty() || "unknown".equalsIgnoreCase(customHeaderValue) || (filteredIP = IPUtils.filterToIPv4(customHeaderValue)) == null) continue;
                if (IPUtils.isPrivateIP(filteredIP)) {
                    if (privateIP != null) continue;
                    privateIP = filteredIP;
                    continue;
                }
                if (publicIP != null) continue;
                publicIP = filteredIP;
            }
        }
        if (headerValues != null) {
            for (String headerValue : headerValues) {
                if (headerValue == null || headerValue.isEmpty() || "unknown".equalsIgnoreCase(headerValue) || (filteredIP = IPUtils.filterToIPv4(headerValue)) == null) continue;
                if (IPUtils.isPrivateIP(filteredIP)) {
                    if (privateIP != null) continue;
                    privateIP = filteredIP;
                    continue;
                }
                if (publicIP != null) continue;
                publicIP = filteredIP;
            }
        }
        if (remoteAddr != null && !remoteAddr.isEmpty() && (filteredRemoteAddr = IPUtils.filterToIPv4(remoteAddr)) != null) {
            if (IPUtils.isPrivateIP(filteredRemoteAddr)) {
                if (privateIP == null) {
                    privateIP = filteredRemoteAddr;
                }
            } else if (publicIP == null) {
                publicIP = filteredRemoteAddr;
            }
        }
        return publicIP != null ? publicIP : privateIP;
    }
}

