/*
 * Decompiled with CFR 0.152.
 */
package com.stclab.botmanager.agent.utils;

import com.stclab.botmanager.agent.config.BotManagerConfig;
import com.stclab.botmanager.agent.utils.CustomSSLSocketFactory;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpUtils {
    private static final String ACCEPT_HEADER = "application/json, text/plain, */*";

    public static String sendGet(String targetUrl, Map<String, String> params, BotManagerConfig config) throws Exception {
        if (config.isAsyncMode()) {
            try {
                return HttpUtils.sendGetAsync(targetUrl, params, config).get();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw new Exception("Async request failed", cause);
            }
        }
        return HttpUtils.sendGetSync(targetUrl, params, config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendGetSync(String targetUrl, Map<String, String> params, BotManagerConfig config) throws Exception {
        String urlWithParams = HttpUtils.buildUrlWithParams(targetUrl, params);
        HttpClientManager clientManager = HttpClientManager.getInstance(config);
        OkHttpClient client = clientManager.getClient();
        Request.Builder requestBuilder = new Request.Builder().url(urlWithParams).addHeader("Accept", ACCEPT_HEADER).get();
        if (config != null && config.getUserAgent() != null) {
            requestBuilder.addHeader("User-Agent", config.getUserAgent());
        }
        Request request = requestBuilder.build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new RuntimeException("HTTP request failed with response code " + response.code());
            }
            if (response.body() == null) {
                String string = "";
                return string;
            }
            String string = response.body().string();
            return string;
        }
        catch (IOException e) {
            throw new Exception("HTTP request failed", e);
        }
    }

    public static CompletableFuture<String> sendGetAsync(String targetUrl, Map<String, String> params, BotManagerConfig config) {
        final CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            String urlWithParams = HttpUtils.buildUrlWithParams(targetUrl, params);
            HttpClientManager clientManager = HttpClientManager.getInstance(config);
            OkHttpClient client = clientManager.getClient();
            Request.Builder requestBuilder = new Request.Builder().url(urlWithParams).addHeader("Accept", ACCEPT_HEADER).get();
            if (config != null && config.getUserAgent() != null) {
                requestBuilder.addHeader("User-Agent", config.getUserAgent());
            }
            Request request = requestBuilder.build();
            Call call = client.newCall(request);
            call.enqueue(new Callback(){

                @Override
                public void onFailure(Call call, IOException e) {
                    future.completeExceptionally(new Exception("HTTP request failed", e));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(Call call, Response response) throws IOException {
                    try {
                        if (!response.isSuccessful()) {
                            future.completeExceptionally(new RuntimeException("HTTP request failed with response code " + response.code()));
                            return;
                        }
                        String responseBody = response.body() != null ? response.body().string() : "";
                        future.complete(responseBody);
                    }
                    catch (IOException e) {
                        future.completeExceptionally(new Exception("Failed to read response", e));
                    }
                    finally {
                        response.close();
                    }
                }
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private static String buildUrlWithParams(String targetUrl, Map<String, String> params) {
        if (params.isEmpty()) {
            return targetUrl;
        }
        StringBuilder queryParams = new StringBuilder(targetUrl.length() + params.size() * 32);
        queryParams.append(targetUrl).append('?');
        boolean first = true;
        for (Map.Entry<String, String> param : params.entrySet()) {
            if (!first) {
                queryParams.append('&');
            }
            queryParams.append(param.getKey()).append('=').append(param.getValue());
            first = false;
        }
        return queryParams.toString();
    }

    private static class HttpClientManager {
        private static volatile HttpClientManager instance;
        private final OkHttpClient httpClient;

        private HttpClientManager(BotManagerConfig config) {
            this.httpClient = this.createHttpClient(config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static HttpClientManager getInstance(BotManagerConfig config) {
            if (instance != null) return instance;
            Class<HttpClientManager> clazz = HttpClientManager.class;
            synchronized (HttpClientManager.class) {
                if (instance != null) return instance;
                instance = new HttpClientManager(config);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
        }

        private OkHttpClient createHttpClient(BotManagerConfig config) {
            ConnectionPool connectionPool = new ConnectionPool(config.getKeepAliveMaxConnections(), config.getKeepAliveTimeout(), TimeUnit.SECONDS);
            OkHttpClient.Builder builder = new OkHttpClient.Builder().connectionPool(connectionPool).connectTimeout(config.getHttpRequestTimeout(), TimeUnit.MILLISECONDS).readTimeout(config.getHttpRequestTimeout(), TimeUnit.MILLISECONDS).writeTimeout(config.getHttpRequestTimeout(), TimeUnit.MILLISECONDS).followRedirects(true).followSslRedirects(true).retryOnConnectionFailure(true);
            try {
                CustomSSLSocketFactory sslFactory = new CustomSSLSocketFactory();
                builder.sslSocketFactory(sslFactory.getSocketFactory(), sslFactory.getTrustManager());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return builder.build();
        }

        public OkHttpClient getClient() {
            return this.httpClient;
        }
    }
}

