/*
 * Decompiled with CFR 0.152.
 */
package com.stclab.botmanager.agent.utils;

import com.stclab.botmanager.agent.utils.TransformUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderCollectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderCollectionUtils.class);

    public static Map<String, String> collectAdditionalHeaders(Object request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (request == null) {
            LOGGER.debug("[BotManager] Request object is null, returning empty headers");
            return headers;
        }
        try {
            String xForwardedFor;
            String referer;
            String protocol;
            String method;
            String contentType;
            String cacheControl;
            String acceptLanguage;
            String acceptEncoding;
            String accept = HeaderCollectionUtils.getHeaderValue(request, "Accept");
            if (accept != null) {
                headers.put("hac", TransformUtils.encodeUri(accept));
            }
            if ((acceptEncoding = HeaderCollectionUtils.getHeaderValue(request, "Accept-Encoding")) != null) {
                headers.put("hace", TransformUtils.encodeUri(acceptEncoding));
            }
            if ((acceptLanguage = HeaderCollectionUtils.getHeaderValue(request, "Accept-Language")) != null) {
                headers.put("hacl", TransformUtils.encodeUri(acceptLanguage));
            }
            if ((cacheControl = HeaderCollectionUtils.getHeaderValue(request, "Cache-Control")) != null) {
                headers.put("hcc", TransformUtils.encodeUri(cacheControl));
            }
            if ((contentType = HeaderCollectionUtils.getHeaderValue(request, "Content-Type")) != null) {
                headers.put("hct", TransformUtils.encodeUri(contentType));
            }
            if ((method = HeaderCollectionUtils.getMethodValue(request)) != null) {
                headers.put("hmtd", method);
            }
            if ((protocol = HeaderCollectionUtils.getProtocolValue(request)) != null) {
                headers.put("hprtc", protocol);
            }
            if ((referer = HeaderCollectionUtils.getHeaderValue(request, "Referer")) != null) {
                headers.put("hreferrer", TransformUtils.encodeUri(referer));
            }
            if ((xForwardedFor = HeaderCollectionUtils.getHeaderValue(request, "X-Forwarded-For")) != null) {
                headers.put("hxff", TransformUtils.encodeUri(xForwardedFor));
            }
        }
        catch (Exception e) {
            LOGGER.error("[BotManager] Error collecting additional headers: {}", (Object)e.getMessage(), (Object)e);
        }
        LOGGER.debug("[BotManager] Collected {} additional headers", (Object)headers.size());
        return headers;
    }

    private static String getHeaderValue(Object request, String headerName) {
        try {
            Method getHeaderMethod = request.getClass().getMethod("getHeader", String.class);
            return (String)getHeaderMethod.invoke(request, headerName);
        }
        catch (Exception e) {
            LOGGER.debug("[BotManager] Failed to get header {}: {}", (Object)headerName, (Object)e.getMessage());
            return null;
        }
    }

    private static String getMethodValue(Object request) {
        try {
            Method getMethodMethod = request.getClass().getMethod("getMethod", new Class[0]);
            return (String)getMethodMethod.invoke(request, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.debug("[BotManager] Failed to get HTTP method: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static String getProtocolValue(Object request) {
        try {
            Method getProtocolMethod = request.getClass().getMethod("getProtocol", new Class[0]);
            return (String)getProtocolMethod.invoke(request, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.debug("[BotManager] Failed to get protocol: {}", (Object)e.getMessage());
            return null;
        }
    }
}

