/*
 * Decompiled with CFR 0.152.
 */
package com.stclab.botmanager.agent.utils;

import com.stclab.botmanager.agent.utils.TransformUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieUtils.class);

    public static String getCookieValue(Object request, String key) {
        try {
            Object[] cookies = (Object[])CookieUtils.invokeMethod(request, "getCookies", null, null);
            if (cookies != null) {
                for (Object cookie : cookies) {
                    String cookieName = (String)CookieUtils.invokeMethod(cookie, "getName", null, null);
                    if (!key.equals(cookieName)) continue;
                    String value = (String)CookieUtils.invokeMethod(cookie, "getValue", null, null);
                    if (key.equals("spf_sid_key") || key.equals("c_bk_sid")) {
                        return TransformUtils.decodeAntiBypass(value);
                    }
                    return value;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[CookieUtils] Failed to get cookie value: {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    public static void setSessionCookie(Object request, Object response, String sessionId) {
        try {
            CookieUtils.setCookie(request, response, "BM-session-id", sessionId, 31536000);
        }
        catch (Exception e) {
            LOGGER.error("[CookieUtils] Failed to set session cookie: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void setLoginCookie(Object request, Object response, String loginId, int maxAge) {
        try {
            String encodedLoginId = TransformUtils.encodeBase64(loginId);
            CookieUtils.setCookie(request, response, "BM-login-id", encodedLoginId, maxAge);
        }
        catch (Exception e) {
            LOGGER.error("[CookieUtils] Failed to set login cookie: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void setAntiBypassCookie(Object request, Object response, String value, int maxAge) {
        try {
            String encodedValue = TransformUtils.encodeAntiBypass(value);
            CookieUtils.setCookie(request, response, "spf_sid_key", encodedValue, maxAge);
        }
        catch (Exception e) {
            LOGGER.error("[CookieUtils] Failed to set anti-bypass cookie: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void setChallengeBypassCookie(Object request, Object response, String value, int maxAge) {
        try {
            String encodedValue = TransformUtils.encodeAntiBypass(value);
            CookieUtils.setCookie(request, response, "c_bk_sid", encodedValue, maxAge);
        }
        catch (Exception e) {
            LOGGER.error("[CookieUtils] Failed to set challenge bypass cookie: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void setCookie(Object request, Object response, String key, String value, int maxAge) {
        try {
            String mainDomain = CookieUtils.getMainDomain(request);
            LOGGER.debug("[CookieUtils] Setting cookie: key={}, value={}, domain={}", key, value, mainDomain);
            Object cookie = CookieUtils.createCookie(key, value);
            if (cookie == null) {
                LOGGER.warn("[CookieUtils] Cookie creation failed for key: {}. Skipping cookie setting.", (Object)key);
                return;
            }
            CookieUtils.invokeMethod(cookie, "setMaxAge", new Class[]{Integer.TYPE}, new Object[]{maxAge});
            CookieUtils.invokeMethod(cookie, "setPath", new Class[]{String.class}, new Object[]{"/"});
            if (!"localhost".equals(mainDomain)) {
                CookieUtils.invokeMethod(cookie, "setDomain", new Class[]{String.class}, new Object[]{mainDomain});
            }
            CookieUtils.setCookieHeader(response, key, value, maxAge, mainDomain, CookieUtils.isSecureRequest(request));
        }
        catch (Exception e) {
            LOGGER.error("[CookieUtils] Failed to set cookie: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void setCookieHeader(Object response, String key, String value, int maxAge, String domain, boolean isSecure) {
        try {
            ArrayList<String> cookieHeaders = new ArrayList<String>();
            StringBuilder cookieHeader = new StringBuilder(key + "=" + value).append("; Max-Age=").append(maxAge).append("; Path=/");
            if (!"localhost".equals(domain)) {
                cookieHeader.append("; Domain=").append(domain);
            }
            if (isSecure) {
                cookieHeader.append("; Secure; SameSite=None");
            }
            cookieHeaders.add(cookieHeader.toString());
            for (String header : cookieHeaders) {
                CookieUtils.invokeMethod(response, "addHeader", new Class[]{String.class, String.class}, new Object[]{"Set-Cookie", header});
            }
        }
        catch (Exception e) {
            LOGGER.error("[CookieUtils] Failed to set cookie header: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static boolean isSecureRequest(Object request) {
        try {
            String forwardedProto = (String)CookieUtils.invokeMethod(request, "getHeader", new Class[]{String.class}, new Object[]{"X-Forwarded-Proto"});
            if (forwardedProto != null && "https".equalsIgnoreCase(forwardedProto)) {
                LOGGER.debug("Request forwarded as HTTPS via X-Forwarded-Proto");
                return true;
            }
            String scheme = (String)CookieUtils.invokeMethod(request, "getScheme", null, null);
            LOGGER.debug("Scheme: {}", (Object)scheme);
            return "https".equalsIgnoreCase(scheme);
        }
        catch (Exception e) {
            LOGGER.warn("[CookieUtils] Failed to determine request scheme. Defaulting to HTTP.");
            return false;
        }
    }

    private static String getMainDomain(Object request) {
        try {
            String host = (String)CookieUtils.invokeMethod(request, "getServerName", null, null);
            LOGGER.debug("Host: {}", (Object)host);
            if ("localhost".equals(host)) {
                return host;
            }
            String[] parts = host.split("\\.");
            if (host.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$")) {
                return "";
            }
            if (parts.length == 1) {
                return host;
            }
            boolean isCountryCodeTLD = parts.length > 2 && parts[parts.length - 1].length() == 2 && parts[parts.length - 2].length() <= 3;
            int domainParts = isCountryCodeTLD && parts.length > 2 ? 3 : 2;
            int startIndex = Math.max(0, parts.length - domainParts);
            String mainDomain = String.join((CharSequence)".", Arrays.copyOfRange(parts, startIndex, parts.length));
            return "." + mainDomain;
        }
        catch (Exception e) {
            LOGGER.error("[CookieUtils] Failed to get main domain: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    private static Object createCookie(String key, String value) {
        try {
            Class<?> cookieClass = Class.forName("jakarta.servlet.http.Cookie");
            return cookieClass.getConstructor(String.class, String.class).newInstance(key, value);
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> cookieClass = Class.forName("javax.servlet.http.Cookie");
                return cookieClass.getConstructor(String.class, String.class).newInstance(key, value);
            }
            catch (Exception ex) {
                LOGGER.error("[CookieUtils] Failed to create cookie for both Jakarta and Java EE environments. Key: {}, Value: {}. Error: {}", key, value, ex.getMessage(), ex);
                return null;
            }
        }
        catch (Exception ex) {
            LOGGER.error("[CookieUtils] Failed to create cookie. Key: {}, Value: {}. Error: {}", key, value, ex.getMessage(), ex);
            return null;
        }
    }

    private static <T> T invokeMethod(Object obj, String methodName, Class<?>[] paramTypes, Object[] args2) throws Exception {
        Method method = obj.getClass().getMethod(methodName, paramTypes);
        return (T)method.invoke(obj, args2);
    }
}

