/*
 * Decompiled with CFR 0.152.
 */
package com.stclab.botmanager.agent.config;

public class BotManagerConfig {
    private final String tenantId;
    private final String domainName;
    private final String serverUrl;
    private final String protectionUrl;
    private final int httpRequestTimeout;
    private final String logLevel;
    private final boolean preventBypass;
    private final int preventBypassMinutes;
    private final int preventBypassGraceSeconds;
    private final int preventBypassMaxAttempts;
    private final int preventBypassChallengeBypassCookieMaxAge;
    private final boolean preventBypassUseChallengeBypassCookie;
    private final String[] customIpHeaders;
    private final boolean useDirectConnectionIp;
    private final int keepAliveTimeout;
    private final int keepAliveMaxConnections;
    private final String userAgent;
    private final boolean asyncMode;

    public BotManagerConfig(String tenantId, String domainName, String serverUrl, String protectionUrl, int httpRequestTimeout, String logLevel, boolean preventBypass, int preventBypassMinutes, int preventBypassGraceSeconds, int preventBypassMaxAttempts, int preventBypassChallengeBypassCookieMaxAge, boolean preventBypassUseChallengeBypassCookie, String[] customIpHeaders, boolean useDirectConnectionIp, int keepAliveTimeout, int keepAliveMaxConnections, String userAgent, boolean asyncMode) {
        this.serverUrl = serverUrl != null && !serverUrl.isEmpty() ? serverUrl : null;
        this.protectionUrl = protectionUrl != null && !protectionUrl.isEmpty() ? protectionUrl : "";
        this.tenantId = tenantId != null && !tenantId.isEmpty() ? tenantId : null;
        this.domainName = domainName != null && !domainName.isEmpty() ? domainName : null;
        this.httpRequestTimeout = httpRequestTimeout > 0 ? httpRequestTimeout : 3000;
        this.logLevel = logLevel != null ? logLevel.toUpperCase() : "ERROR";
        this.preventBypass = preventBypass;
        this.preventBypassMinutes = Math.max(1, preventBypassMinutes);
        this.preventBypassGraceSeconds = Math.max(0, preventBypassGraceSeconds);
        this.preventBypassMaxAttempts = Math.max(1, preventBypassMaxAttempts);
        this.preventBypassChallengeBypassCookieMaxAge = Math.max(60, preventBypassChallengeBypassCookieMaxAge);
        this.preventBypassUseChallengeBypassCookie = preventBypassUseChallengeBypassCookie;
        this.customIpHeaders = customIpHeaders != null ? (String[])customIpHeaders.clone() : null;
        this.useDirectConnectionIp = useDirectConnectionIp;
        this.keepAliveTimeout = Math.max(10, keepAliveTimeout);
        this.keepAliveMaxConnections = Math.max(1, keepAliveMaxConnections);
        this.userAgent = userAgent != null && !userAgent.isEmpty() ? userAgent : "BotManager-Java-Agent/1.0";
        this.asyncMode = asyncMode;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getProtectionUrl() {
        return this.protectionUrl;
    }

    public int getHttpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public boolean isInitialized() {
        return this.serverUrl != null && this.protectionUrl != "" && this.tenantId != null && this.domainName != null;
    }

    @Deprecated
    public String getLogLevel() {
        return this.logLevel;
    }

    public boolean isPreventBypass() {
        return this.preventBypass;
    }

    public int getPreventBypassMinutes() {
        return this.preventBypassMinutes;
    }

    public int getPreventBypassGraceSeconds() {
        return this.preventBypassGraceSeconds;
    }

    public int getPreventBypassMaxAttempts() {
        return this.preventBypassMaxAttempts;
    }

    public int getPreventBypassChallengeBypassCookieMaxAge() {
        return this.preventBypassChallengeBypassCookieMaxAge;
    }

    public boolean isPreventBypassUseChallengeBypassCookie() {
        return this.preventBypassUseChallengeBypassCookie;
    }

    public String[] getCustomIpHeaders() {
        return this.customIpHeaders != null ? (String[])this.customIpHeaders.clone() : null;
    }

    public boolean isUseDirectConnectionIp() {
        return this.useDirectConnectionIp;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public int getKeepAliveMaxConnections() {
        return this.keepAliveMaxConnections;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isAsyncMode() {
        return this.asyncMode;
    }

    public static class Builder {
        private String tenantId;
        private String domainName;
        private String serverUrl;
        private String protectionUrl;
        private int httpRequestTimeout = 3000;
        private String logLevel;
        private boolean preventBypass = false;
        private int preventBypassMinutes = 5;
        private int preventBypassGraceSeconds = 30;
        private int preventBypassMaxAttempts = 3;
        private int preventBypassChallengeBypassCookieMaxAge = 3600;
        private boolean preventBypassUseChallengeBypassCookie = true;
        private String[] customIpHeaders = null;
        private boolean useDirectConnectionIp = false;
        private int keepAliveTimeout = 30;
        private int keepAliveMaxConnections = 20;
        private String userAgent = "BotManager-Java-Agent/1.0";
        private boolean asyncMode = false;

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder protectionUrl(String protectionUrl) {
            this.protectionUrl = protectionUrl;
            return this;
        }

        public Builder httpRequestTimeout(int httpRequestTimeout) {
            this.httpRequestTimeout = httpRequestTimeout;
            return this;
        }

        @Deprecated
        public Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder preventBypass(boolean preventBypass) {
            this.preventBypass = preventBypass;
            return this;
        }

        public Builder preventBypassMinutes(int preventBypassMinutes) {
            this.preventBypassMinutes = preventBypassMinutes;
            return this;
        }

        public Builder preventBypassGraceSeconds(int preventBypassGraceSeconds) {
            this.preventBypassGraceSeconds = preventBypassGraceSeconds;
            return this;
        }

        public Builder preventBypassMaxAttempts(int preventBypassMaxAttempts) {
            this.preventBypassMaxAttempts = preventBypassMaxAttempts;
            return this;
        }

        public Builder preventBypassChallengeBypassCookieMaxAge(int preventBypassChallengeBypassCookieMaxAge) {
            this.preventBypassChallengeBypassCookieMaxAge = preventBypassChallengeBypassCookieMaxAge;
            return this;
        }

        public Builder preventBypassUseChallengeBypassCookie(boolean preventBypassUseChallengeBypassCookie) {
            this.preventBypassUseChallengeBypassCookie = preventBypassUseChallengeBypassCookie;
            return this;
        }

        public Builder customIpHeaders(String ... customIpHeaders) {
            this.customIpHeaders = customIpHeaders != null && customIpHeaders.length > 0 ? (String[])customIpHeaders.clone() : null;
            return this;
        }

        public Builder useDirectConnectionIp(boolean useDirectConnectionIp) {
            this.useDirectConnectionIp = useDirectConnectionIp;
            return this;
        }

        public Builder keepAliveTimeout(int keepAliveTimeout) {
            this.keepAliveTimeout = keepAliveTimeout;
            return this;
        }

        public Builder keepAliveMaxConnections(int keepAliveMaxConnections) {
            this.keepAliveMaxConnections = keepAliveMaxConnections;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder asyncMode(boolean asyncMode) {
            this.asyncMode = asyncMode;
            return this;
        }

        public BotManagerConfig build() {
            return new BotManagerConfig(this.tenantId, this.domainName, this.serverUrl, this.protectionUrl, this.httpRequestTimeout, this.logLevel, this.preventBypass, this.preventBypassMinutes, this.preventBypassGraceSeconds, this.preventBypassMaxAttempts, this.preventBypassChallengeBypassCookieMaxAge, this.preventBypassUseChallengeBypassCookie, this.customIpHeaders, this.useDirectConnectionIp, this.keepAliveTimeout, this.keepAliveMaxConnections, this.userAgent, this.asyncMode);
        }
    }
}

