/*
 * Decompiled with CFR 0.152.
 */
package com.stclab.botmanager.agent.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stclab.botmanager.agent.BotManager;
import com.stclab.botmanager.agent.config.BotManagerConfig;
import com.stclab.botmanager.agent.models.BlockResponse;
import com.stclab.botmanager.agent.models.BlockType;
import com.stclab.botmanager.agent.utils.Constants;
import com.stclab.botmanager.agent.utils.CookieUtils;
import com.stclab.botmanager.agent.utils.HeaderCollectionUtils;
import com.stclab.botmanager.agent.utils.HttpUtils;
import com.stclab.botmanager.agent.utils.IPUtils;
import com.stclab.botmanager.agent.utils.RequestUtils;
import com.stclab.botmanager.agent.utils.TransformUtils;
import com.stclab.botmanager.agent.utils.UUIDUtils;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotManagerDetectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BotManagerDetectionService.class);
    private final BotManagerConfig config;
    private final ObjectMapper objectMapper;

    public BotManagerDetectionService(BotManagerConfig config) {
        this.config = config;
        this.objectMapper = new ObjectMapper();
        LOGGER.info("[BotManager] DetectionService initialized");
    }

    public boolean handleScreenApi(Object request, Object response, Map<String, String> params) {
        try {
            return this.processDetection(request, response, true, params);
        }
        catch (Exception e) {
            this.handleException(e, "handleScreenApi");
            return true;
        }
    }

    public boolean handleConsoleApi(Object request, Object response, Map<String, String> params) {
        try {
            return this.processDetection(request, response, false, params);
        }
        catch (Exception e) {
            this.handleException(e, "handleConsoleApi");
            return true;
        }
    }

    private boolean processDetection(Object request, Object response, boolean isPageRequest, Map<String, String> params) throws Exception {
        if (!this.isConfigInitialized(response)) {
            return true;
        }
        if (this.config.isPreventBypass() && !this.handleAntiBypass(request, response, isPageRequest)) {
            return false;
        }
        return this.continueDetection(request, response, isPageRequest, params);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean continueDetection(Object request, Object response, boolean isPageRequest, Map<String, String> params) throws Exception {
        String redirectUrl;
        String sessionId = this.getSessionId(request, response);
        String domainName = params != null && params.get("domainName") != null ? params.get("domainName") : this.config.getDomainName();
        String tenantId = params != null && params.get("tenantId") != null ? params.get("tenantId") : this.config.getTenantId();
        String clientIp = params != null && params.get("clientIp") != null ? params.get("clientIp") : null;
        boolean hasLoginId = params != null && params.containsKey("loginId");
        boolean hasCustomId = params != null && params.containsKey("customId");
        String loginId = hasLoginId ? params.get("loginId") : "";
        String customId = hasCustomId ? params.get("customId") : "";
        String userId = !customId.isEmpty() ? customId : loginId;
        String cookieLoginId = this.getLoginId(request, response);
        if (!hasLoginId && !hasCustomId) {
            userId = cookieLoginId;
        } else if (userId.isEmpty()) {
            if (!cookieLoginId.isEmpty()) {
                CookieUtils.setLoginCookie(request, response, "", 31536000);
                LOGGER.debug("[BotManager] Clearing login cookie as userId is empty");
            }
        } else if (!userId.equals(cookieLoginId)) {
            CookieUtils.setLoginCookie(request, response, userId, 31536000);
            LOGGER.debug("[BotManager] Updating login cookie. Previous: {}, New: {}", (Object)cookieLoginId, (Object)userId);
        }
        this.invokeMethod(response, "addHeader", new Class[]{String.class, String.class}, new Object[]{"X-BM-Agent-Version", BotManager.getAgentVersion()});
        Map<String, String> requestDetails = this.extractRequestDetails(request, isPageRequest);
        BlockResponse detectionResult = this.sendDetectionRequest(request, response, sessionId, userId, domainName, tenantId, requestDetails, clientIp);
        if (detectionResult.getActionType() != null) {
            int actionType = detectionResult.getActionType();
            if (actionType == 0) {
                if (detectionResult.getDetectionType() <= 0) {
                    LOGGER.debug("[BotManager] ActionType PASS (0) for sessionId: {}", (Object)sessionId);
                    return true;
                }
                LOGGER.debug("[BotManager] ActionType PASS but detectionType > 0 ({}), using legacy logic for sessionId: {}", (Object)detectionResult.getDetectionType(), (Object)sessionId);
            } else {
                String redirectUrl2;
                if (detectionResult.getScreenUrl() != null && !detectionResult.getScreenUrl().isEmpty()) {
                    String baseRedirectUrl = this.buildBaseUrlFromScreenUrl(detectionResult.getScreenUrl());
                    redirectUrl2 = this.buildRedirectUrl(request, baseRedirectUrl, detectionResult, sessionId, userId, requestDetails, null);
                } else {
                    BlockType blockType = BlockType.fromSecondVerifyType(detectionResult.getSecondVerifyType());
                    String baseRedirectUrl = this.config.getProtectionUrl() + blockType.getUrl();
                    redirectUrl2 = this.buildRedirectUrl(request, baseRedirectUrl, detectionResult, sessionId, userId, requestDetails, null);
                }
                LOGGER.info("[BotManager] Block detected (actionType: {}) for sessionId: {}, redirecting to: {}", actionType, sessionId, redirectUrl2);
                this.redirectResponse(response, isPageRequest, redirectUrl2);
                return false;
            }
        }
        if (detectionResult.getDetectionType() <= 0) {
            LOGGER.debug("[BotManager] No block detected for sessionId: {}", (Object)sessionId);
            return true;
        }
        if (detectionResult.getScreenUrl() != null && !detectionResult.getScreenUrl().isEmpty()) {
            String baseRedirectUrl = this.buildBaseUrlFromScreenUrl(detectionResult.getScreenUrl());
            redirectUrl = this.buildRedirectUrl(request, baseRedirectUrl, detectionResult, sessionId, userId, requestDetails, null);
        } else {
            BlockType blockType = BlockType.fromSecondVerifyType(detectionResult.getSecondVerifyType());
            String baseRedirectUrl = this.config.getProtectionUrl() + blockType.getUrl();
            redirectUrl = this.buildRedirectUrl(request, baseRedirectUrl, detectionResult, sessionId, userId, requestDetails, null);
        }
        LOGGER.info("[BotManager] Block detected (detectionType: {}) for sessionId: {}, redirecting to: {}", detectionResult.getDetectionType(), sessionId, redirectUrl);
        this.redirectResponse(response, isPageRequest, redirectUrl);
        return false;
    }

    private boolean handleAntiBypass(Object request, Object response, boolean isPageRequest) throws Exception {
        String[] parts;
        String spfSidKey = CookieUtils.getCookieValue(request, "spf_sid_key");
        String challengeBypassKey = CookieUtils.getCookieValue(request, "c_bk_sid");
        String nnbkState = RequestUtils.getQueryParameter(request, "nnbk_state");
        int maxAttempts = this.config.getPreventBypassMaxAttempts();
        boolean useChallengeBypassCookie = this.config.isPreventBypassUseChallengeBypassCookie();
        int cBkCount = 0;
        int cBkMaxAge = this.config.getPreventBypassChallengeBypassCookieMaxAge();
        if (spfSidKey != null && !spfSidKey.isEmpty()) {
            if (!this.validateSpfSidKey(spfSidKey)) {
                this.redirectToBlockPage(request, response, BlockType.DENY, isPageRequest, null, Constants.ANTI_BYPASS_DENY_BLOCK_TYPE);
                return false;
            }
            return true;
        }
        if (!useChallengeBypassCookie) {
            if (nnbkState != null && !nnbkState.isEmpty()) {
                if (this.validateNnbkState(nnbkState)) {
                    return true;
                }
                this.redirectToBlockPage(request, response, BlockType.DENY, isPageRequest, null, Constants.ANTI_BYPASS_DENY_BLOCK_TYPE);
                return false;
            }
            this.redirectToBlockPage(request, response, BlockType.BROWSER_CHALLENGE, isPageRequest, "fcr=1", Constants.ANTI_BYPASS_CHALLENGE_BLOCK_TYPE);
            return false;
        }
        if (nnbkState != null && !nnbkState.isEmpty() && challengeBypassKey != null && !challengeBypassKey.isEmpty() && (parts = challengeBypassKey.split(":")).length == 2) {
            try {
                cBkCount = Integer.parseInt(parts[1]);
                if (cBkCount >= maxAttempts) {
                    this.redirectToBlockPage(request, response, BlockType.DENY, isPageRequest, null, Constants.ANTI_BYPASS_DENY_BLOCK_TYPE);
                    return false;
                }
                int newCount = cBkCount + 1;
                long nowTimestamp = Instant.now().getEpochSecond();
                String newCBkValue = nowTimestamp + ":" + newCount;
                CookieUtils.setChallengeBypassCookie(request, response, newCBkValue, cBkMaxAge);
                LOGGER.debug("[BotManager] Anti-bypass: Incremented c_bk_sid count to {}", (Object)newCount);
                return true;
            }
            catch (NumberFormatException e) {
                LOGGER.warn("[BotManager] Invalid c_bk_sid format: {}", (Object)challengeBypassKey);
            }
        }
        if (challengeBypassKey != null && !challengeBypassKey.isEmpty() && (parts = challengeBypassKey.split(":")).length == 2) {
            try {
                cBkCount = Integer.parseInt(parts[1]);
                if (cBkCount >= maxAttempts) {
                    this.redirectToBlockPage(request, response, BlockType.DENY, isPageRequest, null, Constants.ANTI_BYPASS_DENY_BLOCK_TYPE);
                    return false;
                }
                int newCount = cBkCount + 1;
                long nowTimestamp = Instant.now().getEpochSecond();
                String newCBkValue = nowTimestamp + ":" + newCount;
                CookieUtils.setChallengeBypassCookie(request, response, newCBkValue, cBkMaxAge);
                return true;
            }
            catch (NumberFormatException e) {
                LOGGER.warn("[BotManager] Invalid c_bk_sid format: {}", (Object)challengeBypassKey);
            }
        }
        if (nnbkState != null && !nnbkState.isEmpty()) {
            if (this.validateNnbkState(nnbkState)) {
                long nowTimestamp = Instant.now().getEpochSecond();
                String challengeBypassValue = nowTimestamp + ":1";
                CookieUtils.setChallengeBypassCookie(request, response, challengeBypassValue, cBkMaxAge);
                return true;
            }
            this.redirectToBlockPage(request, response, BlockType.DENY, isPageRequest, null, Constants.ANTI_BYPASS_DENY_BLOCK_TYPE);
            return false;
        }
        this.redirectToBlockPage(request, response, BlockType.BROWSER_CHALLENGE, isPageRequest, "fcr=1", Constants.ANTI_BYPASS_CHALLENGE_BLOCK_TYPE);
        return false;
    }

    private void redirectToBlockPage(Object request, Object response, BlockType blockType, boolean isPageRequest, String bypassKey, Integer blockTypeValue) throws Exception {
        BlockResponse tempResponse = new BlockResponse();
        tempResponse.setBlockType(blockTypeValue);
        Map<String, String> requestDetails = this.extractRequestDetails(request, isPageRequest);
        String baseRedirectUrl = this.config.getProtectionUrl() + blockType.getUrl();
        String redirectUrl = this.buildRedirectUrl(request, baseRedirectUrl, tempResponse, "", "", requestDetails, bypassKey);
        LOGGER.info("[BotManager] Redirecting to {} page: {}", (Object)blockType.name(), (Object)redirectUrl);
        this.redirectResponse(response, isPageRequest, redirectUrl);
    }

    private boolean validateSpfSidKey(String spfSidKey) {
        try {
            boolean isValid;
            long timestamp = Long.parseLong(spfSidKey);
            long currentTime = Instant.now().getEpochSecond();
            long validitySeconds = this.config.getPreventBypassMinutes() * 60 + this.config.getPreventBypassGraceSeconds();
            boolean bl = isValid = currentTime - timestamp <= validitySeconds;
            if (!isValid) {
                LOGGER.debug("[BotManager] spf_sid_key timestamp expired: {}", (Object)spfSidKey);
            }
            return isValid;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("[BotManager] Invalid spf_sid_key format: {}", (Object)spfSidKey);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("[BotManager] Error validating spf_sid_key: {}", (Object)e.getMessage());
            return false;
        }
    }

    private boolean validateNnbkState(String nnbkState) {
        try {
            long validitySeconds;
            boolean isValid;
            String decoded = TransformUtils.decodeBase64(nnbkState);
            decoded = TransformUtils.decodeBase64(decoded);
            decoded = TransformUtils.decodeBase64(decoded);
            LOGGER.debug("[BotManager] Decoded nnbk_state: {}", (Object)decoded);
            if (!decoded.matches("\\d{10}:1")) {
                LOGGER.warn("[BotManager] Invalid nnbk_state format: {}", (Object)decoded);
                return false;
            }
            String[] parts = decoded.split(":");
            long timestamp = Long.parseLong(parts[0]);
            long currentTime = Instant.now().getEpochSecond();
            boolean bl = isValid = currentTime - timestamp <= (validitySeconds = (long)(this.config.getPreventBypassMinutes() * 60 + this.config.getPreventBypassGraceSeconds()));
            if (!isValid) {
                LOGGER.debug("[BotManager] nnbk_state timestamp expired: {}", (Object)nnbkState);
            }
            return isValid;
        }
        catch (Exception e) {
            LOGGER.error("[BotManager] Error validating nnbk_state: {} - {}", (Object)nnbkState, (Object)e.getMessage());
            return false;
        }
    }

    private boolean hasCookieKey(Object request, String key) {
        try {
            Object[] cookies = (Object[])this.invokeMethod(request, "getCookies", null, null);
            if (cookies != null) {
                for (Object cookie : cookies) {
                    String cookieName = (String)this.invokeMethod(cookie, "getName", null, null);
                    if (!key.equals(cookieName)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[BotManager] Failed to check cookie key: {}", (Object)e.getMessage(), (Object)e);
        }
        return false;
    }

    private void redirectResponse(Object response, boolean isPageRequest, String redirectUrl) throws Exception {
        if (isPageRequest) {
            this.invokeMethod(response, "sendRedirect", new Class[]{String.class}, new Object[]{redirectUrl});
        } else {
            this.invokeMethod(response, "setHeader", new Class[]{String.class, String.class}, new Object[]{"X-BotManager-Location", redirectUrl});
            this.invokeMethod(response, "setHeader", new Class[]{String.class, String.class}, new Object[]{"Access-Control-Allow-Origin", "*"});
            this.invokeMethod(response, "setHeader", new Class[]{String.class, String.class}, new Object[]{"Access-Expose-Headers", "X-BotManager-Location"});
        }
    }

    private BlockResponse sendDetectionRequest(Object request, Object response, String sessionId, String loginId, String domainName, String tenantId, Map<String, String> requestDetails, String providedClientIp) throws Exception {
        String userAgent = (String)this.invokeMethod(request, "getHeader", new Class[]{String.class}, new Object[]{"User-Agent"});
        String clientIp = providedClientIp != null && !providedClientIp.isEmpty() ? providedClientIp : this.getClientIp(request);
        String encodedUserAgent = TransformUtils.encodeUri(userAgent);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tenantId", tenantId);
        params.put("domainName", domainName);
        params.put("loginId", loginId != null ? loginId : "");
        params.put("sessionId", sessionId);
        params.put("pageUrl", requestDetails.get("pageUrl"));
        params.put("queryString", TransformUtils.encodeUri(requestDetails.get("queryString")));
        params.put("userAgent", encodedUserAgent);
        params.put("ip", clientIp);
        params.put("agentTag", BotManager.getAgentVersion());
        Map<String, String> additionalHeaders = HeaderCollectionUtils.collectAdditionalHeaders(request);
        params.putAll(additionalHeaders);
        LOGGER.debug("[BotManager] Sending detection request with params: {}", (Object)params);
        String detectionUrl = this.config.getServerUrl() + "/detect";
        String jsonResponse = HttpUtils.sendGet(detectionUrl, params, this.config);
        LOGGER.debug("[BotManager] Detection server response: {}", (Object)jsonResponse);
        return this.objectMapper.readValue(jsonResponse, BlockResponse.class);
    }

    private boolean isConfigInitialized(Object response) throws Exception {
        if (!this.config.isInitialized()) {
            LOGGER.warn("[BotManager] Configuration not initialized");
            this.invokeMethod(response, "getWriter", null, null).toString();
            return false;
        }
        return true;
    }

    private String getClientIp(Object request) throws Exception {
        String remoteAddr = (String)this.invokeMethod(request, "getRemoteAddr", null, null);
        if (this.config.isUseDirectConnectionIp()) {
            return IPUtils.getBestClientIP(null, remoteAddr, null, true);
        }
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "CF-Connecting-IP", "True-Client-IP", "X-Client-IP", "X-Cluster-Client-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        String[] headerValues = new String[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            headerValues[i] = (String)this.invokeMethod(request, "getHeader", new Class[]{String.class}, new Object[]{headers[i]});
        }
        String[] customHeaderValues = null;
        String[] customHeaders = this.config.getCustomIpHeaders();
        if (customHeaders != null && customHeaders.length > 0) {
            customHeaderValues = new String[customHeaders.length];
            for (int i = 0; i < customHeaders.length; ++i) {
                customHeaderValues[i] = (String)this.invokeMethod(request, "getHeader", new Class[]{String.class}, new Object[]{customHeaders[i]});
            }
        }
        return IPUtils.getBestClientIP(headerValues, remoteAddr, customHeaderValues, false);
    }

    private String buildBaseUrlFromScreenUrl(String screenUrl) {
        String protectionUrl = this.config.getProtectionUrl();
        int protocolEnd = protectionUrl.indexOf("://");
        if (protocolEnd == -1) {
            LOGGER.warn("[BotManager] Invalid protectionUrl format: {}", (Object)protectionUrl);
            return protectionUrl + (screenUrl.startsWith("/") ? "" : "/") + screenUrl;
        }
        int pathStart = protectionUrl.indexOf(47, protocolEnd + 3);
        String baseOrigin = pathStart == -1 ? protectionUrl : protectionUrl.substring(0, pathStart);
        if (screenUrl.startsWith("/")) {
            return baseOrigin + screenUrl;
        }
        return baseOrigin + "/" + screenUrl;
    }

    private String buildRedirectUrl(Object request, String baseRedirectUrl, BlockResponse detectionResult, String sessionId, String loginId, Map<String, String> requestDetails, String bypassKey) {
        StringBuilder redirectUrl = new StringBuilder(baseRedirectUrl).append("?serverUrl=").append(TransformUtils.encodeUri(this.config.getServerUrl())).append("&tenantId=").append(this.config.getTenantId()).append("&domainName=").append(this.config.getDomainName()).append("&detectionType=").append(detectionResult.getDetectionType()).append("&pageUrl=").append(requestDetails.get("pageUrl")).append("&queryString=").append(requestDetails.get("queryString")).append("&sessionId=").append(sessionId).append("&agentTag=").append(BotManager.getAgentVersion()).append("&loginId=").append(TransformUtils.encodeBase64(loginId));
        redirectUrl.append("&redirectUrl=").append(TransformUtils.encodeUri(requestDetails.get("redirectUrl")));
        if (bypassKey != null && !bypassKey.isEmpty()) {
            redirectUrl.append("&").append(bypassKey);
        }
        return redirectUrl.toString();
    }

    private String getSessionId(Object request, Object response) {
        String sessionId = CookieUtils.getCookieValue(request, "BM-session-id");
        if (sessionId == null) {
            sessionId = UUIDUtils.generateUUID();
            CookieUtils.setSessionCookie(request, response, sessionId);
            LOGGER.debug("[BotManager] Setting session cookie for sessionId: {}", (Object)sessionId);
        }
        return sessionId;
    }

    private String getLoginId(Object request, Object response) {
        String encodedLoginId = CookieUtils.getCookieValue(request, "BM-login-id");
        if (encodedLoginId != null) {
            try {
                String uriDecodedLoginId = TransformUtils.decodeUri(encodedLoginId);
                if (TransformUtils.isBase64Encoded(uriDecodedLoginId)) {
                    return TransformUtils.decodeBase64(uriDecodedLoginId);
                }
                CookieUtils.setLoginCookie(request, response, uriDecodedLoginId, 31536000);
                return uriDecodedLoginId;
            }
            catch (Exception e) {
                LOGGER.error("[BotManager] Invalid login ID format, using raw value: {}", (Object)encodedLoginId);
                return encodedLoginId;
            }
        }
        return "";
    }

    private void handleException(Exception e, String methodName) {
        LOGGER.error("[BotManager] Exception in {}: {}", methodName, e.getMessage(), e);
    }

    private Map<String, String> extractRequestDetails(Object request, boolean isPageRequest) {
        HashMap<String, String> details = new HashMap<String, String>();
        String requestUri = "";
        String queryString = "";
        String scheme = "http";
        String host = "";
        int port = -1;
        String redirectUrl = "";
        try {
            requestUri = (String)this.invokeMethod(request, "getRequestURI", null, null);
        }
        catch (Exception e) {
            LOGGER.error("[BotManager] Failed to retrieve request URI: {}", (Object)e.getMessage(), (Object)e);
        }
        try {
            queryString = (String)this.invokeMethod(request, "getQueryString", null, null);
            if (queryString == null) {
                queryString = "";
            } else if (queryString.startsWith("?")) {
                queryString = queryString.substring(1);
            }
        }
        catch (Exception e) {
            LOGGER.error("[BotManager] Failed to retrieve query string: {}", (Object)e.getMessage(), (Object)e);
            queryString = "";
        }
        try {
            scheme = (String)this.invokeMethod(request, "getScheme", null, null);
            host = (String)this.invokeMethod(request, "getServerName", null, null);
            port = (Integer)this.invokeMethod(request, "getServerPort", null, null);
        }
        catch (Exception e) {
            LOGGER.error("[BotManager] Failed to retrieve scheme, host, or port: {}", (Object)e.getMessage(), (Object)e);
        }
        StringBuilder fullUrl = new StringBuilder();
        fullUrl.append(scheme).append("://").append(host);
        if (!(port == -1 || "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443)) {
            fullUrl.append(":").append(port);
        }
        if (requestUri != null) {
            fullUrl.append(requestUri);
        }
        if (!queryString.isEmpty()) {
            fullUrl.append("?").append(queryString);
        }
        redirectUrl = fullUrl.toString();
        details.put("pageUrl", TransformUtils.encodeUri(requestUri));
        details.put("queryString", TransformUtils.encodeUri(queryString));
        details.put("redirectUrl", TransformUtils.encodeUri(redirectUrl));
        return details;
    }

    private <T> T invokeMethod(Object obj, String methodName, Class<?>[] paramTypes, Object[] args2) throws Exception {
        paramTypes = paramTypes != null ? paramTypes : new Class[]{};
        args2 = args2 != null ? args2 : new Object[]{};
        Method method = obj.getClass().getMethod(methodName, paramTypes);
        return (T)method.invoke(obj, args2);
    }
}

