/*
 * Decompiled with CFR 0.152.
 */
package com.stclab.botmanager.agent;

import com.stclab.botmanager.agent.api.BotManagerDetectionService;
import com.stclab.botmanager.agent.config.BotManagerConfig;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BotManager.class);
    private static BotManager instance;
    private BotManagerDetectionService detectionService;

    private BotManager(BotManagerConfig config) {
        this.detectionService = new BotManagerDetectionService(config);
        LOGGER.info("[BotManager] Initialized with tenantId: {}", (Object)config.getTenantId());
    }

    public static void initialize(BotManagerConfig config) {
        if (instance == null) {
            instance = new BotManager(config);
        }
    }

    private static BotManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException("[BotManager] Not initialized. Call initialize() first.");
        }
        return instance;
    }

    public static String getAgentVersion() {
        String version = BotManager.getVersionFromProperties();
        if (version == null || version.isEmpty()) {
            version = BotManager.getVersionFromPackage();
        }
        if (version == null || version.isEmpty()) {
            version = "unknown";
        }
        return "BM-java-agent-" + version;
    }

    private static String getVersionFromProperties() {
        try {
            InputStream is = BotManager.class.getClassLoader().getResourceAsStream("version.properties");
            if (is != null) {
                Properties props = new Properties();
                props.load(is);
                is.close();
                return props.getProperty("version");
            }
        }
        catch (Exception e) {
            LOGGER.debug("[BotManager] Could not read version from properties: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static String getVersionFromPackage() {
        try {
            Package pkg = BotManager.class.getPackage();
            if (pkg != null) {
                return pkg.getImplementationVersion();
            }
        }
        catch (Exception e) {
            LOGGER.debug("[BotManager] Could not read version from package: {}", (Object)e.getMessage());
        }
        return null;
    }

    public static boolean detectPage(Object request, Object response) {
        return BotManager.detectPage(request, response, null);
    }

    public static boolean detectPage(Object request, Object response, Map<String, String> params) {
        try {
            if (instance == null) {
                LOGGER.warn("[BotManager] Not initialized. Call initialize() first.");
                return true;
            }
            return BotManager.getInstance().detectionService.handleScreenApi(request, response, params);
        }
        catch (Exception e) {
            LOGGER.error("[BotManager] Error during detectPage: {}", (Object)e.getMessage(), (Object)e);
            return true;
        }
    }

    public static boolean detectApi(Object request, Object response) {
        return BotManager.detectApi(request, response, null);
    }

    public static boolean detectApi(Object request, Object response, Map<String, String> params) {
        try {
            if (instance == null) {
                LOGGER.warn("[BotManager] Not initialized. Call initialize() first.");
                return true;
            }
            return BotManager.getInstance().detectionService.handleConsoleApi(request, response, params);
        }
        catch (Exception e) {
            LOGGER.error("[BotManager] Error during detectApi: {}", (Object)e.getMessage(), (Object)e);
            return true;
        }
    }
}

